/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.InstallConfigResolver;
import oracle.ops.verification.framework.param.InstallConfigResolverException;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.NativeCLOption;
import oracle.ops.verification.framework.param.NativeCLOptionFactory;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.param.parser.CLSyntax2;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public final class ParamManager {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_fmMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String LSEP = System.getProperty("line.separator");
    private Vector m_paramList = new Vector();
    private boolean b_stage = false;
    private boolean b_comp = false;
    private boolean b_profile = false;
    private boolean b_pre = false;
    private boolean b_post = false;
    private boolean b_help = false;
    private boolean b_verbose = false;
    private boolean b_ver10gR1 = false;
    private boolean b_ver10gR2 = false;
    private boolean b_ver11gR1 = false;
    private boolean b_displayStatus = false;
    private boolean b_version = false;
    private boolean b_diag = false;
    private boolean b_CfsOh = false;
    private boolean m_ASMCheck = false;
    private boolean m_USMCheck = false;
    private boolean b_sshonly = false;
    private boolean b_patchonly = false;
    private boolean b_noctss = false;
    private boolean b_summary = false;
    private boolean b_service = false;
    private boolean b_profile_flag = false;
    private boolean b_format = false;
    private boolean b_server = false;
    private boolean b_client = false;
    private boolean b_dnsLastClient = false;
    private boolean b_preCrsinst = false;
    private boolean b_gnsPostCrsinst = false;
    private String s_version = null;
    private boolean b_postcrsinst = false;
    private boolean b_nodeadd = false;
    private boolean b_fs_orcl = false;
    private boolean b_specifyDomain = false;
    private boolean b_serviceUser = false;
    private boolean b_servicePwd = false;
    private String s_password = null;
    private String s_rootUserName = null;
    private String s_configMethod = null;
    private String s_sudoPbrunLocPath = null;
    private int s_dhcpPort = 67;
    private Hashtable<String, Integer> m_flagsHash = new Hashtable();
    private String[] m_cmdLineArgList = null;
    private Hashtable m_hash = null;
    private String m_cmdLine = null;
    private StringBuffer m_key = null;
    private String m_helpKey = null;
    private int m_argPointer;
    private static ParamManager _paramManager;
    private boolean m_isGroupSupported = true;
    private boolean m_isWindows = true;
    private NativeCLOption m_nativeCLOption;
    private static Vector m_vGenFixedKeys;
    private static Vector m_vNatFixedKeys;
    private String[] m_arrFixedKeys;
    private OperationMode m_mode;
    private static boolean fromRuncluvfy;
    private static boolean m_fromRacHome;
    private String m_instalConfigFile = null;

    public boolean isB_fs_orcl() {
        return this.b_fs_orcl;
    }

    private void addGenFixedKeys() {
        m_vGenFixedKeys.add(CLSyntax.STR_CLUVFY_HELP);
        m_vGenFixedKeys.add(CLSyntax.STR_VERSION);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_HELP);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_LIST);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE_CLUSVC);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE_HACONFIG);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE_USMCFG);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE_DBINST);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE_DBCFG);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_PRE_NODEADD);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST_HWOS);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST_CLUSVC);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST_HACONFIG);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST_USMCFG);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST_NODEADD);
        m_vGenFixedKeys.add(CLSyntax.STR_STAGE_POST_NODEDEL);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_HELP);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_LIST);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_NODECON);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_NODEREACH);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_SSA);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_SPA);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_SYS);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_ADMPRV);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_CLUMGR);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_CLU);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_NODEAPP);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_OCR);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_CRS);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_PEER);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_OLR);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_HA);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_SOFTWARE);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_USM);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_ASM);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_GPNP);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_GNS);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_DHCP);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_DNS);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_SCAN);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_OHASD);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_CTSS);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_VDISK);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_HEALTH);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_HEALTH_CHECK);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_FREE_SPACE);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_FARM_CHECK);
        m_vGenFixedKeys.add(CLSyntax.STR_COMP_BASELINE);
    }

    private void collectFixedKeys() {
        Vector vector = new Vector(m_vGenFixedKeys.subList(0, m_vGenFixedKeys.size()));
        try {
            vector.addAll(m_vNatFixedKeys.subList(0, m_vNatFixedKeys.size()));
        }
        catch (NullPointerException npe) {
            Trace.out((String)"==== Native fixed keys is null.");
        }
        this.m_arrFixedKeys = new String[vector.size()];
        this.m_arrFixedKeys = vector.toArray(this.m_arrFixedKeys);
    }

    boolean isNativeKeyValid(String key) {
        Iterator iterator = m_vNatFixedKeys.iterator();
        while (iterator.hasNext()) {
            if (!key.equals((String)iterator.next())) continue;
            ParamManager.debug_out("==== Valid native key " + key);
            return true;
        }
        return false;
    }

    NativeCLOption getNativeCLOption() {
        return this.m_nativeCLOption;
    }

    private ParamManager(OperationMode mode, String[] args) throws InvalidCommandlineException {
        this.m_mode = mode;
        try {
            if (mode == OperationMode.MODE_CLI) {
                int i;
                String[] actualArgs;
                String clVersion = VerificationUtil.getVersionForCL();
                if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("_FROM_RUNCLUVFY")) {
                    actualArgs = new String[args.length - 1];
                    i = 0;
                    while (i < args.length - 1) {
                        actualArgs[i] = args[i++];
                    }
                    CLSyntax.setRunCluvfyTxt();
                    CLSyntax2.setRunCluvfyTxt();
                    fromRuncluvfy = true;
                    args = actualArgs;
                }
                if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("_FROM_RACHOME")) {
                    actualArgs = new String[args.length - 1];
                    i = 0;
                    while (i < args.length - 1) {
                        actualArgs[i] = args[i++];
                    }
                    m_fromRacHome = true;
                    args = actualArgs;
                }
                this.m_cmdLineArgList = args;
                this.makeCmdLineString();
                CLSyntax2.validate(clVersion, this.m_cmdLineArgList);
                NativeSystem nativeSys = new SystemFactory().CreateSystem();
                this.setGroupSupport(nativeSys.isUnixSystem());
                this.setWindowsSystem(!nativeSys.isUnixSystem());
                this.m_nativeCLOption = NativeCLOptionFactory.getNativeCLOption();
                this.m_nativeCLOption.addFixedKey(m_vNatFixedKeys);
                this.addGenFixedKeys();
                this.collectFixedKeys();
                this.startProcessing();
                this.processConfigFile();
            }
        }
        catch (InvalidCommandlineException e) {
            Trace.out((String)("Key is: " + this.m_key.toString()));
            Trace.out((String)("Help Key is: " + this.m_helpKey));
            String eMsg = e.getMessage();
            String errMsg = "";
            if (this.m_key != null && this.m_key.toString().trim().length() > 0) {
                errMsg = LSEP + s_fmMsgBundle.getMessage("8504", false) + LSEP + e.getMessage();
            }
            throw new InvalidCommandlineException(errMsg + LSEP + CLSyntax2.getUsageText(this.m_cmdLineArgList));
        }
    }

    public static synchronized ParamManager getInstance(OperationMode mode, String[] args) throws InvalidCommandlineException {
        if (_paramManager == null) {
            _paramManager = new ParamManager(mode, args);
        }
        return _paramManager;
    }

    public static ParamManager getInstance() throws UninitializedParamManagerException {
        if (_paramManager == null) {
            throw new UninitializedParamManagerException(s_msgBundle.getMessage("1000", false));
        }
        return _paramManager;
    }

    private void startProcessing() throws InvalidCommandlineException {
        this.m_key = new StringBuffer("");
        if (this.m_cmdLineArgList.length < 1) {
            Trace.out((String)"==== Empty argument list found.");
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
        }
        this.m_argPointer = 0;
        this.m_hash = new Hashtable(this.m_cmdLineArgList.length + 1, 1.0f);
        for (int i = 0; i < this.m_cmdLineArgList.length; ++i) {
            this.m_hash.put(new Integer(i), this.m_cmdLineArgList[i]);
        }
        this.determineKey();
        this.parseForArguments(this.m_argPointer);
        if (this.m_hash.size() > 0) {
            ParamManager.debug_out("*** ERROR: junk arguments found");
            ParamManager.debug_out(this.m_hash.toString());
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
        }
        if (this.m_key.toString().equals(CLSyntax.STR_CLUVFY_HELP) || this.m_key.toString().equals(CLSyntax.STR_STAGE_HELP) || this.m_key.toString().equals(CLSyntax.STR_STAGE_LIST) || this.m_key.toString().equals(CLSyntax.STR_COMP_HELP) || this.m_key.toString().equals(CLSyntax.STR_COMP_LIST)) {
            this.displayUsageAndExit(0);
        }
        if (this.m_key.toString().equals(CLSyntax.STR_VERSION)) {
            this.displayVersionAndExit(0);
        }
    }

    private void processConfigFile() throws InvalidCommandlineException {
        if (this.checkInstallConfigFile()) {
            try {
                InstallConfigResolver installConfigResolver = new InstallConfigResolver();
                installConfigResolver.resolve(this.getInstallConfigFile(), null, null);
                String strNodes = VerificationUtil.getVariableValue("NODE_NAME_LIST");
                if (strNodes != null) {
                    this.m_paramList.removeElement(this.getArgument(Argument.ARG_NODELIST));
                    Argument argObj = new Argument(Argument.ARG_NODELIST);
                    argObj.setArgList(strNodes);
                    this.m_paramList.add(argObj);
                }
            }
            catch (InstallConfigResolverException icre) {
                throw new InvalidCommandlineException(icre.getMessage());
            }
        }
    }

    private void determineKey() throws InvalidCommandlineException {
        this.m_argPointer = 0;
        while (this.m_argPointer < this.m_cmdLineArgList.length) {
            this.m_helpKey = this.m_key.toString();
            this.extendKey(this.m_argPointer, this.m_cmdLineArgList[this.m_argPointer]);
            this.setFlagsForUniqueKey(this.m_cmdLineArgList[this.m_argPointer]);
            this.removeCLArgFromHash(this.m_argPointer);
            if (this.checkUniqueKey()) {
                this.m_helpKey = this.m_key.toString();
                ++this.m_argPointer;
                return;
            }
            ++this.m_argPointer;
        }
        Trace.out((String)"==== Syntax error. Unique key does not exist");
        throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
    }

    private boolean checkUniqueKey() throws InvalidCommandlineException {
        boolean foundOnce = false;
        String key = this.m_key.toString();
        for (int i = 0; i < this.m_arrFixedKeys.length; ++i) {
            String fxkey = this.m_arrFixedKeys[i];
            if (!fxkey.startsWith(key) || !fxkey.equals(key) && key.length() != fxkey.indexOf(".", key.length())) continue;
            if (foundOnce) {
                return false;
            }
            foundOnce = true;
        }
        if (!foundOnce) {
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
        }
        return true;
    }

    private void extendKey(int index, String subkey) {
        if (index > 0) {
            this.m_key.append(".");
        }
        this.m_key.append(subkey);
    }

    private void setFlagsForUniqueKey(String arg) {
        boolean found = false;
        if (arg.equals(CLSyntax.STR_STAGE)) {
            this.b_stage = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_COMPONENT)) {
            this.b_comp = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_PROFILE)) {
            this.b_profile = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_PRE)) {
            this.b_pre = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_POST)) {
            this.b_post = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_HELP)) {
            this.b_help = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_VERSION)) {
            this.b_version = true;
            if (arg.equals(CLSyntax.STR_SERVER)) {
                this.b_server = true;
            }
            found = true;
        }
        if (arg.equals(CLSyntax.STR_CLIENT)) {
            this.b_client = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_GNSPRE)) {
            this.b_preCrsinst = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_GNSPOST)) {
            this.b_gnsPostCrsinst = true;
            found = true;
        }
        if (arg.equals(CLSyntax.STR_GNS_LAST_CLIENT)) {
            this.b_dnsLastClient = true;
            found = true;
        }
    }

    private void removeCLArgFromHash(int index) {
        this.m_hash.remove(new Integer(index));
    }

    private void parseForArguments(int start) throws InvalidCommandlineException {
        int maxlen = this.m_cmdLineArgList.length;
        if (this.checkForFlagInCLArgs(CLSyntax.STR_HELP, start, maxlen)) {
            this.displayUsageAndExit(0);
        }
        this.pickupCLArgsForCommonFlags(start, maxlen);
        this.pickupCLArgsForCluvfyOH(start, maxlen);
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_HWOS)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            this.pickupCLArgsForStorageIDlist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_PRE_CLUSVC)) {
            this.checkForFlagInCLArgs(CLSyntax.STR_FLEX, start, maxlen);
            boolean bNodesPresent = this.pickupCLArgsForNodelist(start, maxlen);
            boolean bConfFilePresent = this.pickupCLArgsForConfigFile(start, maxlen);
            boolean bUpgadePresent = this.checkForFlagInCLArgs(CLSyntax.STR_UPGRADE, start, maxlen);
            if (!(this.checkFlex() || bNodesPresent || bConfFilePresent || bUpgadePresent)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1043", false));
            }
            boolean bAutoListPresent = this.pickupCLArgsForAutolist(start, maxlen);
            boolean bHubListPresent = this.pickupCLArgsForHublist(start, maxlen);
            boolean bRimListPresent = this.pickupCLArgsForRimlist(start, maxlen);
            boolean bTargetHubPresent = this.pickupCLArgsForTargetHubSize(start, maxlen);
            this.pickupCLArgsForRelease(start, maxlen);
            this.pickupCLArgsForOCRLocation(start, maxlen);
            this.pickupCLArgsForVotingDisk(start, maxlen);
            this.pickupCLArgsForOsdba(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_ASMFLAG, start, maxlen);
            this.pickupCLArgsForAsmGrp(start, maxlen);
            this.pickupCLArgsForAsmCreds(start, maxlen);
            this.pickupCLArgsForAsmPresence(start, maxlen);
            this.pickupCLArgsForOrainv(start, maxlen);
            this.pickupCLArgsForASMDev(start, maxlen);
            this.pickupCLArgsForCrsHome(start, maxlen);
            this.pickupCLArgsForCRSVersion(start, maxlen);
            this.pickupCLArgsForSrcCrsHome(start, maxlen);
            this.pickupCLArgsForDestCrsHome(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_ROLLING, start, maxlen);
            this.pickupCLArgsForPatchonlyFlag(start, maxlen);
            this.pickupCLArgsForFixups(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            if ((this.hasArgument(Argument.ARG_ASM_DEVICES) || this.hasArgument(Argument.ARG_GROUP_ASMGRP)) && !this.checkASM()) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1033", false));
            }
            this.pickupCLArgsForNetworklist(start, maxlen);
            boolean dhcpFound = this.pickupCLArgsForDHCPFlag(start, maxlen);
            if (dhcpFound) {
                VerificationUtil.setVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP", "TRUE");
                this.pickupCLArgsForDHCPPort(start, maxlen);
                if (!this.pickupCLArgsForClusterName(start, maxlen)) {
                    throw new InvalidCommandlineException(s_msgBundle.getMessage("1040", false));
                }
                if (!this.isWindowsSystem() && this.s_dhcpPort < 1024) {
                    throw new InvalidCommandlineException(s_msgBundle.getMessage("1052", true, (Object[])new String[]{Integer.toString(this.s_dhcpPort)}));
                }
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_CLUSVC)) {
            this.setArgPostcrsinst(true);
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            this.pickupCLArgsForRootUserName(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            this.pickupCLArgsForSudoPbrunLoc(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_PRE_HACONFIG)) {
            this.pickupCLArgsForOsdba(start, maxlen);
            this.pickupCLArgsForAsmGrp(start, maxlen);
            this.pickupCLArgsForOrainv(start, maxlen);
            this.pickupCLArgsForFixups(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_HACONFIG)) {
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_PRE_DBINST)) {
            boolean bNodesPresent = this.pickupCLArgsForNodelist(start, maxlen);
            boolean bUpgadePresent = this.checkForFlagInCLArgs(CLSyntax.STR_UPGRADE, start, maxlen);
            if (!bNodesPresent && !bUpgadePresent) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3560", false));
            }
            boolean isReleaseSpecified = this.pickupCLArgsForRelease(start, maxlen);
            this.pickupCLArgsForOsdba(start, maxlen);
            this.pickupCLArgsForOSbackup(start, maxlen);
            this.pickupCLArgsForOSdg(start, maxlen);
            this.pickupCLArgsForOSkm(start, maxlen);
            this.pickupCLArgsForOracleHome(start, maxlen);
            this.pickupCLArgsForSourceOracleHome(start, maxlen);
            this.pickupCLArgsForDestOracleHome(start, maxlen);
            this.pickupCLArgsForDBNameList(start, maxlen);
            this.pickupCLArgsForOracleVersion(start, maxlen);
            this.pickupCLArgsForFixups(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            this.pickupCLArgsForASMDiskGroup(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_SERVICEPWD, start, maxlen);
            if (this.pickupCLArgsForServiceUser(start, maxlen, true) && isReleaseSpecified && VerificationUtil.isVersionPre(this.s_version, "12.1")) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3563", false, (Object[])new String[]{this.s_version}));
            }
            this.checkForFlagInCLArgs(CLSyntax.STR_USMFLAG, start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_PRE_DBCFG)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            if (!this.pickupCLArgsForOracleHome(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1006", false));
            }
            this.pickupCLArgsForFixups(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_SERVICEPWD, start, maxlen);
            this.pickupCLArgsForServiceUser(start, maxlen, false);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_PRE_USMCFG)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            this.pickupCLArgsForASMDev(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_USMCFG)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_PRE_NODEADD)) {
            this.b_nodeadd = true;
            this.checkForFlagInCLArgs(CLSyntax.STR_FLEX, start, maxlen);
            boolean bNodeList = this.pickupCLArgsForNodelistNOALL(start, maxlen);
            boolean bAutoList = this.pickupCLArgsForAutolist(start, maxlen);
            boolean bHubList = this.pickupCLArgsForHublist(start, maxlen);
            boolean bRimList = this.pickupCLArgsForRimlist(start, maxlen);
            if (!(bNodeList || bAutoList || bHubList || bRimList)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            this.pickupCLArgsForTargetHubSize(start, maxlen);
            this.pickupCLArgsForVIPlist(start, maxlen);
            this.pickupCLArgsForFixups(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_NODEADD)) {
            if (!this.pickupCLArgsForNodelistNOALL(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_NODEDEL)) {
            if (!this.pickupCLArgsForNodelistNOALL(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_STORADD)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            if (!this.pickupCLArgsForStorageIDlist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1003", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_STAGE_POST_NETMOD)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_NODECON)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            boolean bNetworks = this.pickupCLArgsForNetworklist(start, maxlen);
            boolean bIface = this.pickupCLArgsForInterfacelist(start, maxlen);
            if (bNetworks && bIface) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3562", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_NODEREACH)) {
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            this.pickupCLArgsForSrcnode(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_SSA)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_FLEX, start, maxlen);
            this.pickupCLArgsForAutolist(start, maxlen);
            this.pickupCLArgsForHublist(start, maxlen);
            this.pickupCLArgsForRimlist(start, maxlen);
            this.pickupCLArgsForTargetHubSize(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_ASMFLAG, start, maxlen);
            this.pickupCLArgsForASMDev(start, maxlen);
            this.pickupCLArgsForStorageIDlist(start, maxlen);
            this.pickupCLArgsForOracleFileType(start, maxlen);
            this.pickupCLArgsForRelease(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_SPA)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            if (!this.pickupCLArgsForStorageLocation(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1010", false));
            }
            if (!this.pickupCLArgsForDiskSpace(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1011", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_SYS)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_FLEX, start, maxlen);
            this.pickupCLArgsForAutolist(start, maxlen);
            this.pickupCLArgsForHublist(start, maxlen);
            this.pickupCLArgsForRimlist(start, maxlen);
            this.pickupCLArgsForTargetHubSize(start, maxlen);
            if (!this.pickupCLArgsForProduct(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1007", false));
            }
            this.pickupCLArgsForRelease(start, maxlen);
            this.pickupCLArgsForOsdba(start, maxlen);
            this.pickupCLArgsForOrainv(start, maxlen);
            this.pickupCLArgsForFixups(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_ADMPRV)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            if (!this.pickupCLArgsForOperation(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1012", false));
            }
            String oper = this.getSinglePartArgVal(Argument.ARG_OPERATION);
            if (oper.equals("crs_inst")) {
                this.pickupCLArgsForOrainv(start, maxlen);
                this.pickupCLArgsForAsmGrp(start, maxlen);
            } else if (oper.equals("db_inst")) {
                this.pickupCLArgsForOsdba(start, maxlen);
            } else if (oper.equals("db_config")) {
                if (!this.pickupCLArgsForOracleHome(start, maxlen)) {
                    throw new InvalidCommandlineException(s_msgBundle.getMessage("1006", false));
                }
            } else {
                this.pickupCLArgsForSshonlyFlag(start, maxlen);
            }
            if (!oper.equals("user_equiv")) {
                this.pickupCLArgsForFixups(start, maxlen);
                this.pickupCLArgsForConfigMode(start, maxlen);
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_GPNP)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_GNS)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForGNSCheckFlag(start, maxlen);
            if (this.b_preCrsinst) {
                this.pickupCLArgsForGNSDomain(start, maxlen);
                this.pickupCLArgsForGNSVIP(start, maxlen);
                this.pickupCLArgsForPort(start, maxlen);
                this.pickupCLArgsForNetworklist(start, maxlen);
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_DHCP)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForVIPResName(start, maxlen);
            this.pickupCLArgsForPort(start, maxlen);
            this.pickupCLArgsForRootUserName(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            this.pickupCLArgsForSudoPbrunLoc(start, maxlen);
            this.pickupCLArgsForNetworklist(start, maxlen);
            if (!this.pickupCLArgsForClusterName(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1040", false));
            }
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_DNS)) {
            this.pickupCLArgsForGNSDomain(start, maxlen);
            this.pickupCLArgsForDNSCheckFlags(start, maxlen);
            if (this.b_server) {
                this.pickupCLArgsForGNSVIPAddress(start, maxlen);
            }
            if (this.b_client) {
                this.pickupCLArgsForGNSVIP(start, maxlen);
            }
            this.pickupCLArgsForPort(start, maxlen);
            this.pickupCLArgsForRootUserName(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            this.pickupCLArgsForSudoPbrunLoc(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_OHASD)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_CTSS)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForNoCtssFlag(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_VDISK)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_CLUMGR)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_CLU)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_NODEAPP)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_OCR)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForRootUserName(start, maxlen);
            this.pickupCLArgsForConfigMode(start, maxlen);
            this.pickupCLArgsForSudoPbrunLoc(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_OLR)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_HA)) {
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_FREE_SPACE)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_SOFTWARE)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForOracleHome(start, maxlen);
            this.pickupCLArgsForRelease(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_CRS)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_USM)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForFilesystem(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_ASM)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_SCAN)) {
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_HEALTH_CHECK)) {
            this.checkForFlagInCLArgs(CLSyntax.STR_BESTPRACTICE, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_MANDATORY, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_DEVIATIONS, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_HTML, start, maxlen);
            this.pickupCLArgsForCollect(start, maxlen);
            this.pickupCLArgsForSave(start, maxlen);
            this.pickupCLArgsForDBName(start, maxlen);
            if (this.getSinglePartArgVal(Argument.ARG_DBNAME) != null && CLSyntax.STR_CLUSTER.equals(this.getSinglePartArgVal(Argument.ARG_COLLECT))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1047", false));
            }
            this.m_mode = OperationMode.MODE_BEST_PRACTICE;
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_FARM_CHECK)) {
            if (!this.pickupCLArgsForNodelistNOALL(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            boolean bConfFilePresent = this.pickupCLArgsForConfigFile(start, maxlen);
            this.pickupCLArgsForSummaryFlag(start, maxlen);
            this.processConfigFile();
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_PEER)) {
            boolean hasRefnode = this.pickupCLArgsForRefnode(start, maxlen);
            if (!this.pickupCLArgsForNodelist(start, maxlen)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1002", false));
            }
            String[] nodelist = this.getMultiPartArgVal(Argument.ARG_NODELIST);
            if (hasRefnode) {
                Trace.out((String)"==== Validating refnode ");
                String refNd = this.getSinglePartArgVal(Argument.ARG_REFNODE);
                for (int k = 0; k < nodelist.length; ++k) {
                    if (!refNd.equals(nodelist[k])) continue;
                    throw new InvalidCommandlineException(s_msgBundle.getMessage("2051", false));
                }
            }
            this.pickupCLArgsForRelease(start, maxlen);
            this.pickupCLArgsForOsdba(start, maxlen);
            this.pickupCLArgsForOrainv(start, maxlen);
            return;
        }
        if (this.m_key.toString().equals(CLSyntax.STR_COMP_BASELINE)) {
            this.pickupCLArgsForNodelist(start, maxlen);
            this.pickupCLArgsForCompare(start, maxlen);
            this.pickupCLArgsForSaveDir(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_BESTPRACTICE, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_MANDATORY, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_DEVIATIONS, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_PRINT_MISMATCH, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_ROOTSCRIPT, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_RESOURCE, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_SAVETOALLNODES, start, maxlen);
            this.pickupCLArgsForCollect(start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_BASE_LINE, start, maxlen);
            this.checkForFlagInCLArgs(CLSyntax.STR_BASELINE_BINLIBFILES, start, maxlen);
            this.pickupCLArgsForReportName(start, maxlen);
            this.pickupCLArgsForDBName(start, maxlen);
            this.pickupCLArgsForOracleHome(start, maxlen);
            if (this.getSinglePartArgVal(Argument.ARG_DBNAME) != null && CLSyntax.STR_CLUSTER.equals(this.getSinglePartArgVal(Argument.ARG_COLLECT))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1047", false));
            }
            return;
        }
        this.m_nativeCLOption.parseNativeArguments(this, this.m_key.toString(), start, maxlen);
    }

    boolean pickupCLArgsForVIPResName(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for vipresname");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_VIPRESNAME)) continue;
            Argument argObj = new Argument(Argument.ARG_VIPRESNAME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_VIPRESNAME, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForGNSDomain(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for GNS DomainName");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_GNSDOMAIN)) continue;
            Argument argObj = new Argument(Argument.ARG_GNS_DOMAIN_NAME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_GNSDOMAIN, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            this.b_specifyDomain = true;
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForGNSVIP(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for GNS VIP");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_GNSVIP)) continue;
            Argument argObj = new Argument(Argument.ARG_GNS_VIP);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_GNSVIP, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForGNSVIPAddress(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for GNS VIP address");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_GNSVIP_ADDRESS)) continue;
            Argument argObj = new Argument(Argument.ARG_GNSVIP_ADDRESS);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_GNSVIP_ADDRESS, i + 1);
            String optionValue = this.m_cmdLineArgList[i + 1];
            String[] addressArray = optionValue.split("/");
            if (addressArray.length != 3) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1042", false));
            }
            for (String addrPart : addressArray) {
                if (addrPart.trim().length() != 0) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1042", false));
            }
            argObj.setArgList(optionValue);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForPort(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for port option");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_PORT)) continue;
            Argument argObj = new Argument(Argument.ARG_PORT);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_PORT, i + 1);
            String optionValue = this.m_cmdLineArgList[i + 1];
            try {
                int port = Integer.parseInt(optionValue);
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1041", false, (Object[])new String[]{optionValue}));
            }
            argObj.setArgList(optionValue);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForDHCPPort(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for dhcp port option");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DHCP_PORT)) continue;
            Argument argObj = new Argument(Argument.ARG_PORT);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_PORT, i + 1);
            String optionValue = this.m_cmdLineArgList[i + 1];
            try {
                this.s_dhcpPort = Integer.parseInt(optionValue);
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1041", false, (Object[])new String[]{optionValue}));
            }
            argObj.setArgList(optionValue);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForRootUserName(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for user name");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ROOT_USER)) continue;
            Argument argObj = new Argument(Argument.ARG_USER);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ROOT_USER, i + 1);
            this.s_rootUserName = this.m_cmdLineArgList[i + 1];
            argObj.setArgList(this.s_rootUserName);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForConfigMode(int start, int max) throws InvalidCommandlineException {
        boolean ret = false;
        ParamManager.debug_out("---picking up arguments for configuration method");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_CONFIG_METHOD)) continue;
            ret = true;
            Argument argObj = new Argument(Argument.ARG_ROOT_CONFIG_MODE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_CONFIG_METHOD, i + 1);
            this.s_configMethod = this.m_cmdLineArgList[i + 1];
            argObj.setArgList(this.s_configMethod);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            ret &= this.pickupCLArgsForRootUserName(start, max);
            this.pickupRootUserPassword();
            return ret &= this.pickupCLArgsForSudoPbrunLoc(start, max);
        }
        return ret;
    }

    private void pickupRootUserPassword() throws InvalidCommandlineException {
        try {
            Assert.assertConfigMethodInput(this.s_configMethod);
            ConfigurationSetup.ConfigMethod currConfigMethod = ConfigurationSetup.ConfigMethod.valueOf((String)this.s_configMethod.toUpperCase());
            RootAutomationUtility.readUserCredentialsCLI(currConfigMethod, this.s_sudoPbrunLocPath, this.s_rootUserName);
        }
        catch (VerificationException ve) {
            VerificationLogData.logError("VerificationException:" + ve.getMessage() + Trace.getStackTrace((Throwable)ve));
            Trace.out((String)ve.getMessage());
            Trace.stackTrace((Throwable)ve);
            System.out.println(LSEP + s_fmMsgBundle.getMessage("8504", false) + LSEP + ve.getMessage() + LSEP);
            System.exit(1);
        }
        catch (ConsoleUtilException ce) {
            VerificationLogData.logError("ConsoleUtilException:" + ce.getMessage() + Trace.getStackTrace((Throwable)ce));
            Trace.stackTrace((Throwable)ce);
            String errMsg = s_gMsgBundle.getMessage("9003", true, (Object[])new String[]{this.s_configMethod});
            VerificationLogData.logError(errMsg);
            Trace.out((String)("Console util failed" + ce.getMessage()));
            throw new InvalidCommandlineException(errMsg);
        }
    }

    boolean pickupCLArgsForSudoPbrunLoc(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for Sudo/Pbrun location");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SUDO_PBRUN_LOC)) continue;
            Argument argObj = new Argument(Argument.ARG_SUDO_PBRUN_LOC);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_SUDO_PBRUN_LOC, i + 1);
            this.s_sudoPbrunLocPath = this.m_cmdLineArgList[i + 1];
            argObj.setArgList(this.s_sudoPbrunLocPath);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForCompare(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for Sudo/Pbrun location");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_COMPARE)) continue;
            Argument argObj = new Argument(Argument.ARG_COMPARE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_COMPARE, i + 1);
            this.s_sudoPbrunLocPath = this.m_cmdLineArgList[i + 1];
            argObj.setArgList(this.s_sudoPbrunLocPath);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForClusterName(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for clustername");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_CLUSTERNAME)) continue;
            Argument argObj = new Argument(Argument.ARG_CLUSTERNAME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_CLUSTERNAME, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    private void pickupCLArgsForGNSCheckFlag(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for -precrsinst/-postcrsinst flag ");
        boolean status = false;
        if (this.m_cmdLineArgList[2].equals(CLSyntax.STR_GNSPRE)) {
            status = true;
            this.b_preCrsinst = true;
            this.removeCLArgFromHash(2);
        }
        if (this.m_cmdLineArgList[2].equals(CLSyntax.STR_GNSPOST)) {
            status = true;
            this.b_gnsPostCrsinst = true;
            this.removeCLArgFromHash(2);
        }
        if (!status) {
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
        }
    }

    private void pickupCLArgsForDNSCheckFlags(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for client/server flag ");
        boolean status = false;
        if (this.m_cmdLineArgList[2].equals(CLSyntax.STR_SERVER)) {
            status = true;
            this.b_server = true;
            this.removeCLArgFromHash(2);
        }
        if (this.m_cmdLineArgList[2].equals(CLSyntax.STR_CLIENT)) {
            status = true;
            this.b_client = true;
            this.removeCLArgFromHash(2);
        }
        if (!status) {
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
        }
        if (this.b_client) {
            for (int i = start; i < max; ++i) {
                if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_GNS_LAST_CLIENT)) continue;
                this.b_dnsLastClient = true;
                this.removeCLArgFromHash(i);
            }
        }
    }

    boolean pickupCLArgsForNodelist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for nodelist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_N)) continue;
            Argument argObj = new Argument(Argument.ARG_NODELIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_N, i + 1);
            if (this.m_cmdLineArgList[i + 1].equals(CLSyntax.STR_ALL)) {
                argObj.setAll(true);
            } else {
                ArrayList<String> duplicateNodes = new ArrayList<String>();
                String nodeListString = this.checkAndCorrectDuplicatesInNodeList(this.m_cmdLineArgList[i + 1], duplicateNodes);
                this.checkAndPrintDuplicateNodeListWarning(duplicateNodes, nodeListString);
                argObj.setArgList(nodeListString);
            }
            String[] nodes = argObj.getArgList();
            for (int j = 0; j < nodes.length; ++j) {
                if (ParamManager.assertNonIPString(nodes[j])) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1030", false));
            }
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    private String checkAndCorrectDuplicatesInNodeList(String nodeListStr, List<String> dupNodeList) {
        HashSet<String> uniqueNodes = new HashSet<String>();
        if (!VerificationUtil.isStringGood(nodeListStr)) {
            return nodeListStr;
        }
        StringBuilder sb = new StringBuilder();
        for (String node : nodeListStr.toLowerCase().split(CLSyntax.DELIMETER)) {
            if (uniqueNodes.add(node)) {
                if (sb.length() != 0) {
                    sb.append(CLSyntax.DELIMETER);
                }
                sb.append(node);
                continue;
            }
            dupNodeList.add(node);
        }
        Trace.out((String)("returning uniquenodes " + sb.toString()));
        return sb.toString();
    }

    private void checkAndPrintDuplicateNodeListWarning(List<String> dupNodeList, String nodeList) {
        if (dupNodeList.size() == 0) {
            return;
        }
        String dupNodes = VerificationUtil.strList2List(dupNodeList);
        Trace.out((String)("Nodes " + dupNodes + " were entered multiple times ignoring the duplicate nodes"));
        System.out.println(VerificationConstants.LSEP + s_fmMsgBundle.getMessage("8503", false) + VerificationConstants.LSEP + s_msgBundle.getMessage("1060", false, (Object[])new String[]{dupNodes, nodeList}));
    }

    boolean pickupCLArgsForNodelistNOALL(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for nodelist, do not allow ALL");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_N)) continue;
            Argument argObj = new Argument(Argument.ARG_NODELIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_N, i + 1);
            if (this.m_cmdLineArgList[i + 1].equals(CLSyntax.STR_ALL)) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3503", false, (Object[])new String[]{this.m_cmdLineArgList[i + 1], " <node_list>"}));
            }
            ArrayList<String> duplicateNodes = new ArrayList<String>();
            String nodeListString = this.checkAndCorrectDuplicatesInNodeList(this.m_cmdLineArgList[i + 1], duplicateNodes);
            this.checkAndPrintDuplicateNodeListWarning(duplicateNodes, nodeListString);
            argObj.setArgList(nodeListString);
            String[] nodes = argObj.getArgList();
            for (int j = 0; j < nodes.length; ++j) {
                if (ParamManager.assertNonIPString(nodes[j])) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1030", false));
            }
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForAutolist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for nodelist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_AUTO)) continue;
            Argument argObj = new Argument(Argument.ARG_AUTOLIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_AUTO, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            String[] nodes = argObj.getArgList();
            for (int j = 0; j < nodes.length; ++j) {
                if (ParamManager.assertNonIPString(nodes[j])) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1030", false));
            }
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForHublist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for nodelist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_HUB)) continue;
            Argument argObj = new Argument(Argument.ARG_HUBLIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_HUB, i + 1);
            ArrayList<String> duplicateNodes = new ArrayList<String>();
            String nodeListString = this.checkAndCorrectDuplicatesInNodeList(this.m_cmdLineArgList[i + 1], duplicateNodes);
            this.checkAndPrintDuplicateNodeListWarning(duplicateNodes, nodeListString);
            argObj.setArgList(nodeListString);
            String[] nodes = argObj.getArgList();
            for (int j = 0; j < nodes.length; ++j) {
                if (ParamManager.assertNonIPString(nodes[j])) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1030", false));
            }
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForRimlist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for nodelist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_RIM)) continue;
            Argument argObj = new Argument(Argument.ARG_RIMLIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_RIM, i + 1);
            ArrayList<String> duplicateNodes = new ArrayList<String>();
            String nodeListString = this.checkAndCorrectDuplicatesInNodeList(this.m_cmdLineArgList[i + 1], duplicateNodes);
            this.checkAndPrintDuplicateNodeListWarning(duplicateNodes, nodeListString);
            argObj.setArgList(nodeListString);
            String[] nodes = argObj.getArgList();
            for (int j = 0; j < nodes.length; ++j) {
                if (ParamManager.assertNonIPString(nodes[j])) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1030", false));
            }
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForTargetHubSize(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for port option");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_TARGET_HUB_SIZE)) continue;
            Argument argObj = new Argument(Argument.ARG_TARGET_HUB_SIZE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_TARGET_HUB_SIZE, i + 1);
            String optionValue = this.m_cmdLineArgList[i + 1];
            argObj.setArgList(optionValue);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    private boolean pickupCLArgsForConfigFile(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for install config");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_CFGFILE)) continue;
            Argument argObj = new Argument(Argument.ARG_CFGFILE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_CFGFILE, i + 1);
            this.m_instalConfigFile = this.m_cmdLineArgList[i + 1];
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForInterfacelist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for interfacelist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_I)) continue;
            Argument argObj = new Argument(Argument.ARG_INTERFACELIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_I, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForNetworklist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for interfacelist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_NETWORKS)) continue;
            Argument argObj = new Argument(Argument.ARG_NETWORKLIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_NETWORKS, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForIPlist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for IPlist");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_A)) continue;
            Argument argObj = new Argument(Argument.ARG_IPLIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_A, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForVIPlist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for vip_list");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_GNSVIP)) continue;
            Argument argObj = new Argument(Argument.ARG_GNS_VIP);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_GNSVIP, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForStorageIDlist(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for storage ID list");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_S)) continue;
            Argument argObj = new Argument(Argument.ARG_STORAGEIDLIST);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_S, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForProduct(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for product");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_P)) continue;
            Argument argObj = new Argument(Argument.ARG_PRODUCT);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_P, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1031", false));
            }
            String prodName = this.m_cmdLineArgList[i + 1];
            if (!(prodName.equalsIgnoreCase("crs") || prodName.equalsIgnoreCase("ha") || prodName.equalsIgnoreCase("database"))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1027", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForRelease(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Release");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_R)) continue;
            Argument argObj = new Argument(Argument.ARG_RELEASE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_R, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
            }
            String relName = this.m_cmdLineArgList[i + 1];
            if (!(relName.equalsIgnoreCase("10gR1") || relName.equalsIgnoreCase("10gR2") || relName.equalsIgnoreCase("11gR1") || relName.equalsIgnoreCase("11gR2") || relName.equalsIgnoreCase("10.1") || relName.equalsIgnoreCase("10.2") || relName.equalsIgnoreCase("11.1") || relName.equalsIgnoreCase("11.2") || relName.equalsIgnoreCase("12.1"))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
            }
            this.s_version = relName;
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOracleFileType(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Oracle File Type");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_T)) continue;
            Argument argObj = new Argument(Argument.ARG_ORACLE_FILETYPE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_T, i + 1);
            String relName = this.m_cmdLineArgList[i + 1];
            if (!(relName.equalsIgnoreCase("software") || relName.equalsIgnoreCase("data") || relName.equalsIgnoreCase("ocr_vdisk"))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1039", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForArchitecture(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Architecture");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_P)) continue;
            Argument argObj = new Argument(Argument.ARG_ARCHITECTURE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_P, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForRefnode(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for refnode");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_REFNODE)) continue;
            Argument argObj = new Argument(Argument.ARG_REFNODE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_REFNODE, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1013", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForStorageLocation(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for storage location");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_L)) continue;
            Argument argObj = new Argument(Argument.ARG_STORAGELOCATION);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_L, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1014", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOsdba(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for OSDBA group");
        if (!this.isGroupSupported()) {
            Trace.out((String)"==== Returning false since groups are not supported");
            return false;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_OSDBA)) continue;
            Argument argObj = new Argument(Argument.ARG_GROUP_OSDBA);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_OSDBA, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1015", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOSbackup(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for OSBACKUP group");
        if (!this.isGroupSupported()) {
            Trace.out((String)"==== Returning false since groups are not supported");
            return false;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_OSBACKUP)) continue;
            Argument argObj = new Argument(Argument.ARG_GROUP_OSBACKUP);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_OSBACKUP, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("5001", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOSdg(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for OSDG group");
        if (!this.isGroupSupported()) {
            Trace.out((String)"==== Returning false since groups are not supported");
            return false;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_OSDG)) continue;
            Argument argObj = new Argument(Argument.ARG_GROUP_OSDG);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_OSDG, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("5003", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOSkm(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for OSKM group");
        if (!this.isGroupSupported()) {
            Trace.out((String)"==== Returning false since groups are not supported");
            return false;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_OSKM)) continue;
            Argument argObj = new Argument(Argument.ARG_GROUP_OSKM);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_OSKM, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("5005", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForAsmGrp(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for ASMADMIN group");
        if (!this.isGroupSupported()) {
            Trace.out((String)"==== Returning false since groups are not supported");
            return false;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ASMGRP)) continue;
            Argument argObj = new Argument(Argument.ARG_GROUP_ASMGRP);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ASMGRP, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1038", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForAsmCreds(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for ASM CREDS file");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ASM_CRED)) continue;
            Argument argObj = new Argument(Argument.ARG_ASM_CRED_FILE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ASM_CRED, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            VerificationUtil.setVariableValue("ASM_CLIENTDATA", this.m_cmdLineArgList[i + 1]);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForAsmPresence(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for ASM presence");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ASM_PRESENCE)) continue;
            Argument argObj = new Argument(Argument.ARG_ASM_PRESENCE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ASM_PRESENCE, i + 1);
            if (!(this.m_cmdLineArgList[i + 1].equalsIgnoreCase("LOCAL") || this.m_cmdLineArgList[i + 1].equalsIgnoreCase("NEAR") || this.m_cmdLineArgList[i + 1].equalsIgnoreCase("FAR"))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            VerificationUtil.setVariableValue("ASMCONFIG", this.m_cmdLineArgList[i + 1]);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOrainv(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for ORAINV group");
        if (!this.isGroupSupported()) {
            Trace.out((String)"==== Returning false since groups are not supported");
            return false;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ORAINV)) continue;
            Argument argObj = new Argument(Argument.ARG_GROUP_ORAINV);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ORAINV, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1016", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForSrcnode(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---picking up args for srcnode");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SRCNODE)) continue;
            Argument argObj = new Argument(Argument.ARG_SRCNODE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_SRCNODE, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1017", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOperation(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Operation");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_O)) continue;
            Argument argObj = new Argument(Argument.ARG_OPERATION);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_O, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1018", false));
            }
            if (!(this.m_cmdLineArgList[i + 1].equals("user_equiv") || this.m_cmdLineArgList[i + 1].equals("cfs_inst") || this.m_cmdLineArgList[i + 1].equals("db_inst") || this.m_cmdLineArgList[i + 1].equals("crs_inst") || this.m_cmdLineArgList[i + 1].equals("db_config"))) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1019", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForFilesystem(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Filesystem");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_F)) continue;
            Argument argObj = new Argument(Argument.ARG_FILESYSTEM);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_F, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1020", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOCRLocation(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for OCR location");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_C)) continue;
            Argument argObj = new Argument(Argument.ARG_OCRLOCATION);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_C, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForCrsHome(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for CRS home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_CRS_HOME)) continue;
            Argument argObj = new Argument(Argument.ARG_CRSHOME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_CRS_HOME, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1023", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForSrcCrsHome(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for SRC CRS home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SRC_CRSHOME)) continue;
            Argument argObj = new Argument(Argument.ARG_SRC_CRSHOME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_SRC_CRSHOME, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1023", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForDestCrsHome(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for DEST CRS home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DEST_CRSHOME)) continue;
            Argument argObj = new Argument(Argument.ARG_DEST_CRSHOME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_DEST_CRSHOME, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1023", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForCRSVersion(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for CRS version");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DEST_VERSION)) continue;
            Argument argObj = new Argument(Argument.ARG_CRS_VERSION);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_DEST_VERSION, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3554", false));
            }
            if (!this.assertValidVersion(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3561", false, (Object[])new String[]{this.m_cmdLineArgList[i + 1]}));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForSourceOracleHome(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for old db home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SRC_DBHOME)) continue;
            Argument argObj = new Argument(Argument.ARG_SRC_DBHOME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_SRC_DBHOME, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1025", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForDestOracleHome(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for dest db home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DEST_DBHOME)) continue;
            Argument argObj = new Argument(Argument.ARG_DEST_DBHOME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_DEST_DBHOME, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1025", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForDBNameList(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for db name");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DBNAME)) continue;
            Argument argObj = new Argument(Argument.ARG_DBNAME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_DBNAME, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOracleVersion(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Db version");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DEST_VERSION)) continue;
            Argument argObj = new Argument(Argument.ARG_DB_VERSION);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_DEST_VERSION, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3554", false));
            }
            if (!this.assertValidVersion(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("3561", false, (Object[])new String[]{this.m_cmdLineArgList[i + 1]}));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForCRSPorts(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for CRS ports");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_T)) continue;
            Argument argObj = new Argument(Argument.ARG_CRSPORTS);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_T, i + 1);
            boolean valid = true;
            Vector v = VerificationUtil.getTokens(this.m_cmdLineArgList[i + 1], CLSyntax.DELIMETER);
            for (int n = 0; n < v.size(); ++n) {
                try {
                    int portnum = Integer.parseInt((String)v.elementAt(n));
                    if (portnum < 0 || portnum > 65535) {
                        valid = false;
                    }
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
                if (valid) continue;
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1024", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForVotingDisk(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Voting Disk");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_Q)) continue;
            Argument argObj = new Argument(Argument.ARG_VOTINGDISK);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_Q, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForOracleHome(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Oracle home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_D)) continue;
            Argument argObj = new Argument(Argument.ARG_ORACLEHOME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_D, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1025", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForSave(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for savedir");
        this.checkForFlagInCLArgs(CLSyntax.STR_SAVE, start, max);
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SAVEDIR)) continue;
            Integer inx_save = this.m_flagsHash.get(CLSyntax.STR_SAVE);
            if (inx_save == null || inx_save + 1 != i) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1046", false));
            }
            Argument argObj = new Argument(Argument.ARG_SAVEDIR);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_SAVEDIR, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1045", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForSaveDir(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for savedir");
        this.checkForFlagInCLArgs(CLSyntax.STR_SAVE, start, max);
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SAVEDIR)) continue;
            Argument argObj = new Argument(Argument.ARG_SAVEDIR);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_SAVEDIR, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1045", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForReportName(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for db name");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_REPORT_NAME)) continue;
            Argument argObj = new Argument(Argument.ARG_REPORT_NAME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_REPORT_NAME, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForDBName(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for db name");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_DB)) continue;
            Argument argObj = new Argument(Argument.ARG_DBNAME);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_DB, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1025", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForCollect(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for db name");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_COLLECT)) continue;
            Argument argObj = new Argument(Argument.ARG_COLLECT);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_COLLECT, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForCluvfyOH(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Cluvfy's Oracle home");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_CLUVFY_OH)) continue;
            Argument argObj = new Argument(Argument.ARG_CLUVFY_OH);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_CLUVFY_OH, i + 1);
            if (!this.assertSingleValue(this.m_cmdLineArgList[i + 1])) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1025", false));
            }
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForFixups(int start, int max) throws InvalidCommandlineException {
        this.checkForFlagInCLArgs(CLSyntax.STR_FIXUP_NO_EXECUTE, start, max);
        return this.checkForFlagInCLArgs(CLSyntax.STR_FIXUP, start, max);
    }

    boolean pickupCLArgsForDHCPFlag(int start, int max) throws InvalidCommandlineException {
        return this.checkForFlagInCLArgs(CLSyntax.STR_DHCP_FLAG, start, max);
    }

    boolean pickupCLArgsForDiskSpace(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Disk space");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_Z)) continue;
            Argument argObj = new Argument(Argument.ARG_DISKSPACE);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_Z, i + 1);
            String token = this.m_cmdLineArgList[i + 1];
            boolean valid = true;
            String dskSpaceTxt = token.substring(0, token.length() - 1);
            long size = -1L;
            try {
                size = Long.parseLong(dskSpaceTxt);
                valid = size <= 0L ? false : valid;
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("====Invalid int value '" + dskSpaceTxt + "' for space check: "));
                valid = false;
            }
            long unit = -1L;
            if (token.endsWith(CLSyntax.STR_SIZE_BYTE)) {
                unit = 1L;
            } else if (token.endsWith(CLSyntax.STR_SIZE_KILO)) {
                unit = 1024L;
            } else if (token.endsWith(CLSyntax.STR_SIZE_MEGA)) {
                unit = 0x100000L;
            } else if (token.endsWith(CLSyntax.STR_SIZE_GIGA)) {
                unit = 0x40000000L;
            }
            boolean bl = valid = unit > 0L ? valid : false;
            if (!valid) {
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1026", false));
            }
            Trace.out((String)("==== Disk space: size:" + size + ", unit in bytes:" + unit));
            if (size >= Long.MAX_VALUE / unit) {
                Trace.out((String)("==== Exceeded max disk space size of " + Long.MAX_VALUE / unit));
                throw new InvalidCommandlineException(s_msgBundle.getMessage("1029", false));
            }
            argObj.setArgList("" + size * unit);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    private void pickupCLArgsForCommonFlags(int start, int max) {
        ParamManager.debug_out("---Picking up args for common options");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i))) continue;
            if (this.m_cmdLineArgList[i].equals(CLSyntax.STR_VERBOSE)) {
                this.b_verbose = true;
                this.removeCLArgFromHash(i);
            }
            if (this.m_cmdLineArgList[i].equals(CLSyntax.STR_DISPLAYSTATUS)) {
                this.b_displayStatus = true;
                this.removeCLArgFromHash(i);
            }
            if (this.m_cmdLineArgList[i].equals(CLSyntax.STR_DIAG)) {
                this.b_diag = true;
                this.removeCLArgFromHash(i);
            }
            if (this.m_cmdLineArgList[i].equals(CLSyntax.STR_DISPLAYSTATUS)) {
                this.b_displayStatus = true;
                this.removeCLArgFromHash(i);
            }
            if (this.m_cmdLineArgList[i].equals(CLSyntax.STR_DIAG)) {
                this.b_diag = true;
                this.removeCLArgFromHash(i);
            }
            if (!this.m_cmdLineArgList[i].equals(CLSyntax.STR_FORMAT)) continue;
            this.b_format = true;
            this.removeCLArgFromHash(i);
        }
    }

    private void pickupCLArgsForSshonlyFlag(int start, int max) {
        ParamManager.debug_out("---Picking up args for sshonly flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SSH_ONLY)) continue;
            this.b_sshonly = true;
            this.removeCLArgFromHash(i);
        }
    }

    private void pickupCLArgsForPatchonlyFlag(int start, int max) {
        ParamManager.debug_out("---Picking up args for _patch_only flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_PATCH_ONLY)) continue;
            this.b_patchonly = true;
            this.removeCLArgFromHash(i);
        }
    }

    private void pickupCLArgsForNoCtssFlag(int start, int max) {
        ParamManager.debug_out("---Picking up args for sshonly flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_NOCTSS)) continue;
            this.b_noctss = true;
            this.removeCLArgFromHash(i);
        }
    }

    private void pickupCLArgsForSummaryFlag(int start, int max) {
        ParamManager.debug_out("---Picking up args for summary flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SUMMARY)) continue;
            this.b_summary = true;
            this.removeCLArgFromHash(i);
        }
    }

    boolean pickupCLArgsForASMDev(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for ASM devices list");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ASMDEV)) continue;
            Argument argObj = new Argument(Argument.ARG_ASM_DEVICES);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ASMDEV, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    boolean pickupCLArgsForASMDiskGroup(int start, int max) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for ASM diskgroup list");
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_ASMDG)) continue;
            Trace.out((String)"ASMDG argument found...");
            Argument argObj = new Argument(Argument.ARG_ASM_DISKGROUP);
            this.removeCLArgFromHash(i);
            this.assertOptionValExists(CLSyntax.STR_ASMDG, i + 1);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            return true;
        }
        return false;
    }

    private void pickupCLArgsForServiceFlag(int start, int max) {
        ParamManager.debug_out("---Picking up args for service flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_SERVICE)) continue;
            this.b_service = true;
            this.removeCLArgFromHash(i);
        }
    }

    private void pickupCLArgsForProfileFlag(int start, int max) {
        ParamManager.debug_out("---Picking up args for profile flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(CLSyntax.STR_PROFILE_FLAG)) continue;
            this.b_profile_flag = true;
            this.removeCLArgFromHash(i);
        }
    }

    boolean pickupCLArgsForServiceUser(int start, int max, boolean isBoth) throws InvalidCommandlineException {
        ParamManager.debug_out("---Picking up args for Windows service user");
        if (!isBoth) {
            Integer inx_servicepwd = this.m_flagsHash.get(CLSyntax.STR_SERVICEPWD);
            if (inx_servicepwd == null) {
                return true;
            }
            this.removeCLArgFromHash(inx_servicepwd);
            String destloc = VerificationUtil.getDestLoc();
            String srcloc = VerificationUtil.getCVHome();
            Argument argOracleHome = this.getArgument(Argument.ARG_ORACLEHOME);
            String oracleHome = argOracleHome.getArgList()[0];
            ParamManager.debug_out("oracle home is " + oracleHome);
            try {
                ParamManager.debug_out("getting winsecurity factory and user");
                WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
                Home home = wsecFac.getHome(oracleHome, new Version());
                String username = home.getServiceUserFromHomePath().getUsername();
                this.pickupServiceUserPassword(username);
            }
            catch (WindowsSecurityException e) {
                Trace.out((String)("WSE when trying to get home user " + e.getMessage()));
                throw new InvalidCommandlineException(e.getMessage());
            }
            return true;
        }
        for (int i = start; i < max - 1; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals("-serviceuser")) continue;
            Trace.out((String)"service user argument found...");
            this.b_serviceUser = true;
            Argument argObj = new Argument(Argument.ARG_SERVICE_USER);
            this.removeCLArgFromHash(i);
            argObj.setArgList(this.m_cmdLineArgList[i + 1]);
            this.removeCLArgFromHash(i + 1);
            this.m_paramList.add(argObj);
            Integer inx_servicepwd = this.m_flagsHash.get(CLSyntax.STR_SERVICEPWD);
            if (inx_servicepwd != null) {
                this.removeCLArgFromHash(inx_servicepwd);
                this.pickupServiceUserPassword(this.m_cmdLineArgList[i + 1]);
                this.removeCLArgFromHash(inx_servicepwd);
            }
            return true;
        }
        return false;
    }

    private void pickupServiceUserPassword(String username) throws InvalidCommandlineException {
        this.b_servicePwd = true;
        try {
            ConsoleUtil consoleUtil = new ConsoleUtil();
            String passwdMessage = s_msgBundle.getMessage("1048", false, (Object[])new String[]{username});
            this.s_password = new String(consoleUtil.readPassword(passwdMessage));
        }
        catch (ConsoleUtilException e) {
            Trace.out((String)("Console util failed" + e.getMessage()));
            throw new InvalidCommandlineException(e.getMessage());
        }
    }

    private void makeCmdLineString() {
        for (int i = 0; i < this.m_cmdLineArgList.length; ++i) {
            if (this.m_cmdLineArgList[i] == null) continue;
            this.m_cmdLine = this.m_cmdLine + " " + this.m_cmdLineArgList[i];
        }
    }

    public static boolean isRuncluvfy() {
        return fromRuncluvfy;
    }

    public static boolean isRacHome() {
        return m_fromRacHome;
    }

    public OperationMode getMode() {
        return this.m_mode;
    }

    public boolean checkInstallConfigFile() {
        return this.m_instalConfigFile != null;
    }

    public String getInstallConfigFile() {
        return this.m_instalConfigFile;
    }

    public Argument[] getArgList() {
        Object[] arglist = new Argument[this.m_paramList.size()];
        this.m_paramList.copyInto(arglist);
        return arglist;
    }

    public boolean checkArgStage() {
        return this.b_stage;
    }

    public String getStageID() {
        return this.getStageCompID();
    }

    public boolean checkArgPre() {
        return this.b_pre;
    }

    public boolean checkArgPost() {
        return this.b_post;
    }

    public boolean checkArgComp() {
        return this.b_comp;
    }

    public boolean checkArgServer() {
        return this.b_server;
    }

    public boolean checkArgPostcrsinst() {
        return this.b_postcrsinst;
    }

    public void setArgPostcrsinst(boolean barg) {
        this.b_postcrsinst = barg;
    }

    public boolean checkArgClient() {
        return this.b_client;
    }

    public boolean checkArgLastClient() {
        return this.b_dnsLastClient;
    }

    public boolean checkArgGnsPreCrsinst() {
        return this.b_preCrsinst;
    }

    public boolean checkArgGnsPostCrsinst() {
        return this.b_gnsPostCrsinst;
    }

    public String getCompID() {
        return this.getStageCompID();
    }

    private String getStageCompID() {
        String key = this.m_key.toString();
        String id = key.substring(key.lastIndexOf(".") + ".".length());
        return id;
    }

    public boolean checkArgProfile() {
        return this.b_profile;
    }

    public boolean checkArgHelp() {
        return this.b_help;
    }

    public boolean checkArgVerbose() {
        return this.b_verbose;
    }

    public boolean checkArgFormat() {
        return this.b_format;
    }

    public boolean checkArgDeviations() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_DEVIATIONS);
    }

    public boolean checkArgHTML() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_HTML);
    }

    public boolean checkArgBestPractice() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_BESTPRACTICE);
    }

    public boolean checkArgMandatory() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_MANDATORY);
    }

    public boolean checkArgDisplayStatus() {
        return this.b_displayStatus;
    }

    public boolean checkArgVer10gR1() {
        return this.b_ver10gR1;
    }

    public boolean checkArgVer10gR2() {
        return this.b_ver10gR2;
    }

    public boolean checkArgSshonly() {
        return this.b_sshonly;
    }

    public boolean checkArgPatchonly() {
        return this.b_patchonly;
    }

    public boolean checkArgNoCtss() {
        return this.b_noctss;
    }

    public boolean checkArgSummary() {
        return this.b_summary;
    }

    public boolean checkArgVersion() {
        return this.b_version;
    }

    public boolean checkArgDiag() {
        return this.b_diag;
    }

    public boolean checkArgCfsOh() {
        return this.b_CfsOh;
    }

    public boolean checkASM() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_ASMFLAG);
    }

    public boolean checkFlex() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_FLEX);
    }

    public boolean checkUSM() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_USMFLAG);
    }

    public boolean checkArgService() {
        return this.b_service;
    }

    public boolean checkArgProfileFlag() {
        return this.b_profile_flag;
    }

    public boolean checkArgFixup() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_FIXUP);
    }

    public boolean checkArgFixupNoExecute() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_FIXUP_NO_EXECUTE);
    }

    public boolean isRootUserNameSpecified() {
        return this.s_rootUserName != null && this.s_rootUserName.trim().length() > 0;
    }

    public String getRootUserName() {
        return this.s_rootUserName;
    }

    public String getConfigMethodStr() {
        return this.s_configMethod;
    }

    public boolean isSudoPbrunLocSpecified() {
        return this.s_sudoPbrunLocPath != null && this.s_sudoPbrunLocPath.trim().length() > 0;
    }

    public String getSudoPbrunLocationStr() {
        return this.s_sudoPbrunLocPath;
    }

    public boolean isConfigMethodSpecified() {
        return this.s_configMethod != null && this.s_configMethod.trim().length() > 0;
    }

    public boolean checkArgSave() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_SAVE);
    }

    public boolean checkArgRolling() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_ROLLING);
    }

    public boolean checkArgUpgrade() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_UPGRADE);
    }

    public boolean isGNSDomainSpecified() {
        return this.b_specifyDomain;
    }

    public boolean isServicePwdSpecified() {
        return this.b_servicePwd;
    }

    public boolean isServiceUserSpecified() {
        return this.b_serviceUser;
    }

    public String getServiceUserPassword() {
        return this.s_password;
    }

    public String getLogFileName() {
        return "cvu.log";
    }

    public boolean hasArgument(int argType) {
        for (int i = 0; i < this.m_paramList.size(); ++i) {
            if (argType != ((Argument)this.m_paramList.elementAt(i)).getArgType()) continue;
            return true;
        }
        return false;
    }

    public Argument getArgument(int argType) {
        for (int i = 0; i < this.m_paramList.size(); ++i) {
            if (argType != ((Argument)this.m_paramList.elementAt(i)).getArgType()) continue;
            Trace.out((String)("Found argtype = " + argType));
            return (Argument)this.m_paramList.elementAt(i);
        }
        return null;
    }

    public String[] getMultiPartArgVal(int argType) {
        Trace.out((String)("Retrieving argument of type = " + argType));
        Argument arg = this.getArgument(argType);
        if (arg != null) {
            return arg.getArgList();
        }
        return null;
    }

    public String getSinglePartArgVal(int argType) {
        String[] args = this.getMultiPartArgVal(argType);
        if (args == null || args.length == 0) {
            return null;
        }
        return args[0];
    }

    public boolean isGroupSupported() {
        return this.m_isGroupSupported;
    }

    public void setGroupSupport(boolean support) {
        this.m_isGroupSupported = support;
        Trace.out((String)("==== Is group options supported? " + support));
    }

    public boolean isWindowsSystem() {
        return this.m_isWindows;
    }

    public boolean isNodeAdd() {
        return this.b_nodeadd;
    }

    public void setWindowsSystem(boolean win) {
        this.m_isWindows = win;
        Trace.out((String)("==== Is Windows system? " + win));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Command line arguments: " + LSEP);
        for (int i = 0; i < this.m_cmdLineArgList.length; ++i) {
            sb.append(this.m_cmdLineArgList[i] + " ");
        }
        sb.append(LSEP + "ParamManager object contains:" + LSEP);
        sb.append(LSEP + "\tcheckArgStage returns: " + this.checkArgStage());
        sb.append(LSEP + "\tcheckArgComp returns: " + this.checkArgComp());
        sb.append(LSEP + "\tcheckArgPre returns: " + this.checkArgPre());
        sb.append(LSEP + "\tcheckArgPost returns: " + this.checkArgPost());
        sb.append(LSEP + "\tcheckArgProfile returns: " + this.checkArgProfile());
        sb.append(LSEP + "\tcheckArgHelp returns: " + this.checkArgHelp());
        sb.append(LSEP + "\tcheckArgVerbose returns: " + this.checkArgVerbose());
        sb.append(LSEP + "\tcheckArgVer10gR1 returns: " + this.checkArgVer10gR1());
        sb.append(LSEP + "\tcheckArgVer10gR2 returns: " + this.checkArgVer10gR2());
        sb.append(LSEP + "\tcheckArgDisplayStatus returns: " + this.checkArgDisplayStatus());
        sb.append(LSEP + "\tcheckArgVersion returns: " + this.checkArgVersion());
        sb.append(LSEP + "\tcheckArgDiag returns: " + this.checkArgDiag());
        sb.append(LSEP + "\tcheckArgSshonly returns: " + this.checkArgSshonly());
        Argument[] arglist = this.getArgList();
        for (int i = 0; i < arglist.length; ++i) {
            sb.append(LSEP + "\tArgument[" + i + "] contains:");
            sb.append(arglist[i]);
        }
        return sb.toString();
    }

    public String getCommandLineString() {
        return this.m_cmdLine;
    }

    boolean isOCFSSupported() {
        return this.isNativeKeyValid(CLSyntax.STR_COMP_CFS);
    }

    private boolean assertSingleValue(String arg) {
        return -1 == arg.indexOf(CLSyntax.DELIMETER);
    }

    private boolean assertValidVersion(String arg) {
        Pattern userNamePattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+).(\\d+)");
        Matcher m = userNamePattern.matcher(arg);
        return m.matches();
    }

    private static boolean assertNonIPString(String nodename) {
        String[] tokens = VerificationUtil.getTokensAsArray(nodename, ".");
        for (int i = 0; i < tokens.length; ++i) {
            try {
                Long.parseLong(tokens[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    private static void debug_out(String text) {
        Trace.out((String)text);
    }

    public static void main(String[] args) {
        try {
            ParamManager pm = new ParamManager(OperationMode.MODE_CLI, args);
            if (pm.hasArgument(Argument.ARG_NODELIST)) {
                String[] nodelist = pm.getMultiPartArgVal(Argument.ARG_NODELIST);
                for (int i = 0; i < nodelist.length; ++i) {
                    ParamManager.debug_out("*** Node[" + i + "] " + nodelist[i]);
                }
            }
        }
        catch (InvalidCommandlineException e) {
            ParamManager.debug_out("Syntax error??" + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean checkForFlagInCLArgs(String flag, int start, int max) {
        ParamManager.debug_out("---Picking up args for '" + flag + "' flag ");
        for (int i = start; i < max; ++i) {
            if (!this.m_hash.containsKey(new Integer(i)) || !this.m_cmdLineArgList[i].equals(flag)) continue;
            this.m_flagsHash.put(flag, new Integer(i));
            this.removeCLArgFromHash(i);
            return true;
        }
        return false;
    }

    private void assertOptionValExists(String option, int valInx) throws InvalidCommandlineException {
        if (this.m_hash.isEmpty() || this.m_cmdLineArgList[valInx].startsWith("-") || this.m_cmdLineArgList[valInx].length() == 0 || this.m_cmdLineArgList[valInx] == null) {
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1037", false, (Object[])new String[]{option}));
        }
    }

    private void displayUsageAndExit(int exitStat) {
        System.out.println(LSEP + CLSyntax2.getUsageText(this.m_cmdLineArgList));
        System.exit(exitStat);
    }

    private void displayVersionAndExit(int exitStat) {
        System.out.println(CLSyntax2.getVersionText());
        System.exit(exitStat);
    }

    static {
        m_vGenFixedKeys = new Vector(32);
        m_vNatFixedKeys = new Vector(4);
        fromRuncluvfy = false;
        m_fromRacHome = false;
    }

    public static enum OperationMode {
        MODE_CLI,
        MODE_API,
        MODE_BEST_PRACTICE;

    }
}

